import asyncio
import json

from py_pli.pylib import VUnits, Measurements, send_msg
# from py_pli.pylib import EndPointType, URPCFunctions
from pylog.pylogger import PyLogger
from virtualunits.HAL import HAL

# 2022-05-02/kstruebing
# from fleming.system_test.fle_sys import get_datafile, get_pwm_status, write_temp, temp_sensors, pwm_status

# Path and scriptname
# PATH, SCRIPT = os.path.split(__file__)

# Name of this script without .py for data-output files
# BASE_NAME = SCRIPT.split('.')[0]

'''
Data-Aquisition

    # Each testfunction has it's own testname
    TEST_NAME = 'avu_cool'
    # Assign the next filename for data-output
    file_name = get_datafile(PATH, BASE_NAME, TEST_NAME)
    # Measurement loop
    for sample in range(samples):
        # write_temp gets values of all temp-sensors and write them into filename
        temp_values = await write_temp(file_name, sample)
'''

import time


async def upper_heating(setpoint, enable=0):
    if enable == 0:
        await VUnits.instance.hal.upper_Heating.disable()
    elif enable == 1:
        await VUnits.instance.hal.upper_Heating.InitializeDevice()
        await VUnits.instance.hal.upper_Heating.set_target_temperature(setpoint)
        await VUnits.instance.hal.upper_Heating.enable()


async def lower_heating(setpoint, enable=0):
    if enable == 0:
        await VUnits.instance.hal.lower_Heating.disable()
    elif enable == 1:
        await VUnits.instance.hal.lower_Heating.InitializeDevice()
        await VUnits.instance.hal.lower_Heating.set_target_temperature(setpoint)
        await VUnits.instance.hal.lower_Heating.enable()


async def avu_heating(setpoint, enable=0):
    if enable == 0:
        await VUnits.instance.hal.lower_Heating.disable()
    elif enable == 1:
        await VUnits.instance.hal.airVentilation_Heating.InitializeDevice()
        await VUnits.instance.hal.airVentilation_Heating.set_target_temperature(setpoint)
        await VUnits.instance.hal.airVentilation_Heating.enable()


async def avu_cooling(setpoint, enable=0):
    if enable == 0:
        await VUnits.instance.hal.lower_Heating.disable()
    elif enable == 1:
        await VUnits.instance.hal.airVentilation_Cooling.InitializeDevice()
        await VUnits.instance.hal.airVentilation_Cooling.set_target_temperature(setpoint)
        await VUnits.instance.hal.airVentilation_Cooling.enable()


async def reset_mainboard():
    msg = {'result': f'reset mainboard...'}
    await send_msg(json.dumps(msg))

    mainboard = 0x0020
    node = URPCFunctions.instance.endPointsDic.get(mainboard)
    PyLogger.logger.info(f"Reset Mainboard")
    try:
        await node.Reset()
        await asyncio.sleep(5)
    except:
        PyLogger.logger.info(f"Reset Mainboard not possible!")
    finally:
        PyLogger.logger.info(f"Reset Mainboard done")


async def start_firmware():
    msg = {'result': f'start firmware...'}
    await send_msg(json.dumps(msg))

    mainboard = 0x0020
    node = URPCFunctions.instance.endPointsDic.get(mainboard)
    await node.StartFirmware()
    await asyncio.sleep(8)
    PyLogger.logger.info(f"Startup Mainboard firmware done!")


async def get_temp_value_from_sensor(sensor_number):
    mainboard = 0x0020
    node = URPCFunctions.instance.endPointsDic.get(mainboard)
    temp_val = round((await node.GetAnalogInput(sensor_number))[0] * 256, 2)
    return temp_val


async def get_ambient_temp_value_from_sensor():
    mainboard = 0x0020
    node = URPCFunctions.instance.endPointsDic.get(mainboard)
    temp_val = round((await node.GetAnalogInput(16))[0] * 175, 2)
    return temp_val


async def wait_until_reach_setpoint(temp_sensor, setpoint):
    start_time = time.time()

    wait = 1
    while (wait):
        threshold_time = time.time()
        temperature = await get_temp_value_from_sensor(temp_sensor)
        if temperature >= setpoint:
            msg = {'result': f'Setpoint has been reached after {round(threshold_time - start_time, 2)}s'}
            await send_msg(json.dumps(msg))
            PyLogger.logger.info(f"Setpoint has been reached after {round(threshold_time - start_time, 2)}s")
            wait = 0
        else:
            await asyncio.sleep(1)
            msg = {'result': f'wait until setpoint has been reached...Temperature: {temperature} Setpoint: {setpoint}'}
            await send_msg(json.dumps(msg))
            PyLogger.logger.info(
                f"wait until setpoint has been reached...Temperature: {temperature} Setpoint: {setpoint}")


async def wait_until_duration_of_measurement(duration=3600):
    msg = {'result': f'measurement started'}
    await send_msg(json.dumps(msg))
    PyLogger.logger.info(f"measurement started")

    time_to_sleep = duration
    while (time_to_sleep):
        time_to_sleep -= 1
        msg = {'result': f'measurement ends in {time_to_sleep}s'}
        await send_msg(json.dumps(msg))
        PyLogger.logger.info(f"measurement ends in {time_to_sleep}s")
        await asyncio.sleep(1)


async def two_degrees_above_ambient_temp(temp_sensor, duration=3600):
    await reset_mainboard()
    await start_firmware()

    ambient_sensor = 4
    two_degrees = 2
    ambient_temp = await get_temp_value_from_sensor(ambient_sensor)
    setpoint = ambient_temp + two_degrees
    msg = {'result': f'ambient temperature = {ambient_temp} °C setpoint = {setpoint}°C'}
    await send_msg(json.dumps(msg))

    await upper_heating(setpoint, enable=1)
    await lower_heating(setpoint, enable=1)
    await avu_heating(setpoint, enable=1)

    msg = {'result': f'initialized devices...'}
    await send_msg(json.dumps(msg))
    await asyncio.sleep(10)

    await wait_until_reach_setpoint(temp_sensor=temp_sensor, setpoint=setpoint)
    await wait_until_duration_of_measurement(duration)

    await upper_heating(setpoint, enable=0)
    await lower_heating(setpoint, enable=0)
    await avu_heating(setpoint, enable=0)
    PyLogger.logger.info(f"Finished, disable all temp_control")
    return f"two_degrees_above_ambient_temp done, all units disabled"


async def heat_with_foil_to_setpoint(temp_sensor, setpoint, duration=3600):
    await reset_mainboard()
    await start_firmware()

    await upper_heating(setpoint, enable=1)
    await lower_heating(setpoint, enable=1)

    await asyncio.sleep(10)

    await wait_until_reach_setpoint(temp_sensor=temp_sensor, setpoint=setpoint)
    await wait_until_duration_of_measurement(duration)

    await upper_heating(setpoint, enable=0)
    await lower_heating(setpoint, enable=0)
    return f"heat_with_foil_to_setpoint done, all units disabled"


async def heat_with_foil_and_avu_to_setpoint(temp_sensor, setpoint, duration=3600):
    await reset_mainboard()
    await start_firmware()

    await upper_heating(setpoint, enable=1)
    await lower_heating(setpoint, enable=1)
    await avu_heating(setpoint, enable=1)

    await asyncio.sleep(10)

    await wait_until_reach_setpoint(temp_sensor=temp_sensor, setpoint=setpoint)
    await wait_until_duration_of_measurement(duration)

    await upper_heating(setpoint, enable=0)
    await lower_heating(setpoint, enable=0)
    await avu_heating(setpoint, enable=0)
    return f"heat_with_foil_and_avu_to_setpoint done, all units disabled"


async def heat_with_upper_heating_to_setpoint(temp_sensor, setpoint, duration=3600):
    await reset_mainboard()
    await start_firmware()

    await upper_heating(setpoint, enable=1)

    await asyncio.sleep(10)

    await wait_until_reach_setpoint(temp_sensor=temp_sensor, setpoint=setpoint)
    await wait_until_duration_of_measurement(duration)

    await upper_heating(setpoint, enable=0)
    return f"heat_with_upper_heating_to_setpoint done, all units disabled"


async def heat_with_lower_heating_to_setpoint(temp_sensor, setpoint, duration=3600):
    await reset_mainboard()
    await start_firmware()

    await lower_heating(setpoint, enable=1)

    await asyncio.sleep(10)

    await wait_until_reach_setpoint(temp_sensor=temp_sensor, setpoint=setpoint)
    await wait_until_duration_of_measurement(duration)

    await lower_heating(setpoint, enable=0)
    return f"heat_with_lower_heating_to_setpoint done, all units disabled"


async def heat_with_avu_to_setpoint(temp_sensor, setpoint, duration=3600):
    await reset_mainboard()
    await start_firmware()

    await avu_heating(setpoint, enable=1)

    await asyncio.sleep(10)

    await wait_until_reach_setpoint(temp_sensor=temp_sensor, setpoint=setpoint)
    await wait_until_duration_of_measurement(duration)

    await avu_heating(setpoint, enable=0)
    return f"heat_with_avu_to_setpoint done, all units disabled"


async def cool_with_avu_to_setpoint(temp_sensor, setpoint, duration=3600):
    await reset_mainboard()
    await start_firmware()

    await avu_cooling(setpoint, enable=1)

    await asyncio.sleep(10)

    await wait_until_reach_setpoint(temp_sensor=temp_sensor, setpoint=setpoint)
    await wait_until_duration_of_measurement(duration)

    await avu_cooling(setpoint, enable=0)
    return f"cool_with_avu_to_setpoint done, all units disabled"


async def heat_with_foil_and_move_scantable(temp_sensor, setpoint, duration=3600):
    await reset_mainboard()
    await start_firmware()

    await upper_heating(setpoint, enable=1)
    await lower_heating(setpoint, enable=1)

    await asyncio.sleep(10)
    PyLogger.logger.info(f"Scantable move to Position 0, 0")
    await VUnits.instance.hal.scan_table.Move(0, 0)

    await wait_until_reach_setpoint(temp_sensor=temp_sensor, setpoint=setpoint)
    await asyncio.sleep(2000)
    PyLogger.logger.info(f"Scantable move to Position 85, 0 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(85, 0)
    await asyncio.sleep(900)
    PyLogger.logger.info(f"Scantable move to Position 170, 0 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(170, 0)
    await asyncio.sleep(900)
    PyLogger.logger.info(f"Scantable move to Position 170, 85 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(170, 85)
    await asyncio.sleep(900)
    PyLogger.logger.info(f"Scantable move to Position 85, 85 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(85, 85)
    await asyncio.sleep(900)
    PyLogger.logger.info(f"Scantable move to Position 0, 85 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(0, 85)
    await asyncio.sleep(900)
    PyLogger.logger.info(f"Scantable move to Position 0, 170 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(0, 170)
    await asyncio.sleep(900)
    PyLogger.logger.info(f"Scantable move to Position 85, 170 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(85, 170)
    await asyncio.sleep(900)
    PyLogger.logger.info(f"Scantable move to Position 170, 170 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(170, 170)
    await asyncio.sleep(900)

    await upper_heating(setpoint, enable=0)
    await lower_heating(setpoint, enable=0)

    PyLogger.logger.info(f"heat_with_foil_and_move_scantable done, all units disabled")


async def cooling_to_ambient_and_move_scantable(temp_sensor, duration=3600):
    # await reset_mainboard()
    # await start_firmware()
    # await VUnits.instance.hal.InitializeDevice()
    await VUnits.instance.hal.scan_table.Home()
    ambient_temp = await get_ambient_temp_value_from_sensor()
    await avu_cooling(setpoint=ambient_temp, enable=1)
    PyLogger.logger.info(f"ambient_temp:   {ambient_temp}")

    await asyncio.sleep(10)
    PyLogger.logger.info(f"Scantable move to Position 0, 0")
    await VUnits.instance.hal.scan_table.Move(0, 0)

    start_time = time.time()

    wait = 1
    while (wait):
        threshold_time = time.time()
        temperature = await get_temp_value_from_sensor(temp_sensor)
        PyLogger.logger.info(f"temperature:   {temperature}")
        if temperature <= ambient_temp:
            msg = {'result': f'Setpoint has been reached after {round(threshold_time - start_time, 2)}s'}
            await send_msg(json.dumps(msg))
            PyLogger.logger.info(f"Setpoint has been reached after {round(threshold_time - start_time, 2)}s")
            wait = 0
        else:
            await asyncio.sleep(1)
            msg = {'result': f'wait until setpoint has been reached...'}
            await send_msg(json.dumps(msg))
            PyLogger.logger.info(f"wait until setpoint has been reached...")

    await asyncio.sleep(900)
    PyLogger.logger.info(f"Scantable move to Position 85, 0 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(85, 0)
    await asyncio.sleep(900)
    PyLogger.logger.info(f"Scantable move to Position 170, 0 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(170, 0)
    await asyncio.sleep(900)
    PyLogger.logger.info(f"Scantable move to Position 170, 85 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(170, 85)
    await asyncio.sleep(900)
    PyLogger.logger.info(f"Scantable move to Position 85, 85 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(85, 85)
    await asyncio.sleep(900)
    PyLogger.logger.info(f"Scantable move to Position 0, 85 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(0, 85)
    await asyncio.sleep(900)
    PyLogger.logger.info(f"Scantable move to Position 0, 170 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(0, 170)
    await asyncio.sleep(900)
    PyLogger.logger.info(f"Scantable move to Position 85, 170 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(85, 170)
    await asyncio.sleep(900)
    PyLogger.logger.info(f"Scantable move to Position 170, 170 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(170, 170)
    await asyncio.sleep(900)

    await avu_cooling(setpoint=ambient_temp, enable=0)
    PyLogger.logger.info(f"cooling_to_ambient_temp and_move_scantable done, all units disabled")


async def heat_with_foil_and_avu_h_and_move_scantable(temp_sensor, setpoint, duration=3600):
    # 2022-05-02/kstruebing
    # TEST_NAME = 'heat_foil_avu_scantable'
    # Assign the next filename for data-output
    # file_name = get_datafile(PATH, BASE_NAME, TEST_NAME)

    # Measurement loop
    # for sample in range(samples):
    # write_temp gets values of all temp-sensors and write them into filename
    #    temp_values = await write_temp(file_name, sample)

    # await reset_mainboard()
    # await start_firmware()
    # await asyncio.sleep(12)
    await VUnits.instance.hal.InitializeDevice()
    await VUnits.instance.hal.scan_table.Home()

    await upper_heating(setpoint, enable=1)
    await lower_heating(setpoint, enable=1)
    await avu_heating(setpoint, enable=1)

    # start_timer = time.time()
    # sample = time.time() - start_timer
    # temp_values = await write_temp(file_name, sample)

    await asyncio.sleep(10)
    PyLogger.logger.info(f"Scantable move to Position 0, 0")
    await VUnits.instance.hal.scan_table.Move(0, 0)

    # sample = time.time() - start_timer
    # temp_values = await write_temp(file_name, sample)

    await wait_until_reach_setpoint(temp_sensor=temp_sensor, setpoint=setpoint)
    await asyncio.sleep(1800)

    PyLogger.logger.info(f"Scantable move to Position 85, 0 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(85, 0)
    # sample = time.time() - start_timer
    # temp_values = await write_temp(file_name, sample)

    await asyncio.sleep(900)
    PyLogger.logger.info(f"Scantable move to Position 170, 0 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(170, 0)
    # sample = time.time() - start_timer
    # temp_values = await write_temp(file_name, sample)

    await asyncio.sleep(900)
    PyLogger.logger.info(f"Scantable move to Position 170, 85 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(170, 85)
    # sample = time.time() - start_timer
    # temp_values = await write_temp(file_name, sample)

    await asyncio.sleep(900)
    PyLogger.logger.info(f"Scantable move to Position 85, 85 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(85, 85)
    # sample = time.time() - start_timer
    # temp_values = await write_temp(file_name, sample)

    await asyncio.sleep(900)
    PyLogger.logger.info(f"Scantable move to Position 0, 85 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(0, 85)
    # sample = time.time() - start_timer
    # temp_values = await write_temp(file_name, sample)

    await asyncio.sleep(900)
    PyLogger.logger.info(f"Scantable move to Position 0, 170 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(0, 170)
    # sample = time.time() - start_timer
    # temp_values = await write_temp(file_name, sample)

    await asyncio.sleep(900)
    PyLogger.logger.info(f"Scantable move to Position 85, 170 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(85, 170)
    # sample = time.time() - start_timer
    # temp_values = await write_temp(file_name, sample)

    await asyncio.sleep(900)
    PyLogger.logger.info(f"Scantable move to Position 170, 170 and wait 15min")
    await VUnits.instance.hal.scan_table.Move(170, 170)
    # sample = time.time() - start_timer
    # temp_values = await write_temp(file_name, sample)

    await asyncio.sleep(900)

    # sample = time.time() - start_timer
    # temp_values = await write_temp(file_name, sample)

    await upper_heating(setpoint, enable=0)
    await lower_heating(setpoint, enable=0)
    await avu_heating(setpoint, enable=0)

    PyLogger.logger.info(f"heat_with_foil_and_avu_h_move_scantable done, all units disabled")


async def heatmap_scantable_movement(time_to_wait=900):

    msg = {'result': f'Start heatmap_scantable_movement'}
    await send_msg(json.dumps(msg))

    position_list = [[0, 0],
                     [85, 0],
                     [170, 0],
                     [170, 85],
                     [85, 85],
                     [0, 85],
                     [0, 170],
                     [85, 170],
                     [170, 170]]

    await VUnits.instance.hal.focusMover.Move(15)
    await VUnits.instance.hal.usLumFocusMover.Move(10)
    for position in position_list:

        msg_text = f'Move to Position {position}'
        msg = {'result': f'{msg_text}'}
        await send_msg(json.dumps(msg))
        await VUnits.instance.hal.scan_table.Move(position[0], position[1])
        msg = {'result': f'wait {time_to_wait}s...'}
        await send_msg(json.dumps(msg))
        await asyncio.sleep(time_to_wait)
    msg = {'result': f'finished !'}
    await send_msg(json.dumps(msg))

async def condensation_prevention():
    msg = {'result': f'sorry, not available yet'}
    await send_msg(json.dumps(msg))